<?php

/**

||-> Shortcode: Countdown

*/

namespace Elementor;

class esio_show_countdown_widget extends Widget_Base {
  public function get_name() {
    return 'countdown';
  }

  public function get_title() {
    return 'Esio - Countdown';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'date',
        [
          'label' => __( 'Date', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::DATE_TIME,
          'picker_options' => array('enableTime' => true, 'minuteIncrement' => 1 ),
          'default' => '2024-12-31 23:59'
        ]
    );

    $this->add_control(
      'digits_font_size',
        [
          'label' => __( 'Digits font size', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::NUMBER,
          'default' => '60'
        ]
    );

    $this->add_control(
      'texts_font_size',
        [
          'label' => __( 'Texts Font Size', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::NUMBER,
          'default' => '16'
        ]
    );

    $this->add_control(
      'digit_color',
        [
          'label' => __( 'Digits Color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
          'default' => '#ffffff',
          'description' => __( 'Pick the color for the digits', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'text_color',
        [
          'label' => __( 'Text Color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
          'default' => '#ffffff',
          'description' => __( 'Pick the color for the text', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'box_bg_color',
        [
          'label' => __( 'Box Background Color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
          'default' => '#ffffff',
          'description' => __( 'Pick the color for the background', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'box_border_radius',
        [
          'label' => __( 'Box Border radius', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::NUMBER,
          'default' => '3'
        ]
    );

    $this->add_control(
      'box_width',
        [
          'label' => __( 'Box padding', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::NUMBER,
          'default' => '200'
        ]
    );

    $this->add_control(
      'box_margin',
        [
          'label' => __( 'Box margin', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::NUMBER,
          'default' => '15'
        ]
    );


    $this->end_controls_section();
  }


  protected function render() {
    global $esio_redux;
    $settings         = $this->get_settings_for_display();
    $date    = $settings['date'];
    $digits_font_size      = $settings['digits_font_size'];
    $texts_font_size       = $settings['texts_font_size'];
    $digit_color           = $settings['digit_color'];
    $text_color            = $settings['text_color'];
    $box_bg_color          = $settings['box_bg_color'];
    $box_border_radius     = $settings['box_border_radius'];
    $box_width             = $settings['box_width'];
    $box_margin            = $settings['box_margin'];


    // DIGITS STYLE
    $digit_style = '';
    if (isset($digit_color)) {
      $digit_style .= 'color:'.$digit_color.';';
    }
    if (isset($digits_font_size)) {
      $digit_style .= 'font-size: '.$digits_font_size.'px;';
    }

    // LABELS STYLE
    $text_style = '';
    if (isset($text_color)) {
      $text_style .= 'color:'.$text_color.' !important;';
    }
    if (isset($texts_font_size)) {
      $text_style .= 'font-size: '.$texts_font_size.'px;';
    }

    // BOX STYLE
    $box_style = '';
    if (isset($box_width)) {
      $box_style = 'width:'.$box_width.'px;';
    }
    if (isset($box_border_radius)) {
      $box_style .= 'border-radius: '.$box_border_radius.'px;';
    }
    if (isset($box_bg_color)) {
      $box_style .= 'background-color: '.$box_bg_color.';';
    }
    if (isset($box_margin)) {
      $box_style .= 'margin: '.$box_margin.'px;';
    }


    $uniqueID = 'countdown_'.uniqid();

    $content = '';
    $content .= '<div class="text-center"><div id="'.$uniqueID.'" class="modeltheme-countdown"></div></div>';
    $content .= '<script type="text/javascript">
                  jQuery( document ).ready(function() {

                    //get each width
                    var width_days'.$uniqueID.' = jQuery(\'.rev_slider #'.$uniqueID.' .days-digit\').width();
                    var width_hours'.$uniqueID.' = jQuery(\'.rev_slider #'.$uniqueID.' .hours-digit\').width();
                    var width_minutes'.$uniqueID.' = jQuery(\'.rev_slider #'.$uniqueID.' .minutes-digit\').width();
                    var width_seconds'.$uniqueID.' = jQuery(\'.rev_slider #'.$uniqueID.' .seconds-digit\').width();
                    var width_dots'.$uniqueID.' = jQuery(\'.rev_slider #'.$uniqueID.' .c_dot\').width();
                    var width_dots_x3'.$uniqueID.' = width_dots'.$uniqueID.'*7;
                    //total width
                    var width_sum'.$uniqueID.' = width_days'.$uniqueID.'+width_hours'.$uniqueID.'+width_minutes'.$uniqueID.'+width_seconds'.$uniqueID.'+width_dots_x3'.$uniqueID.';
                    //test
                    //console.log(width_sum'.$uniqueID.');
                    //apply width
                    jQuery(".rev_slider #'.$uniqueID.'").width(width_sum'.$uniqueID.');


                    jQuery("#'.$uniqueID.'").countdown("'.$date.'", function(event) {
                      jQuery(this).html(
                        event.strftime("<div class=\'days\'>"
                                          +"<div class=\'days-digit\'>%D</div>"
                                          +"<div class=\'clearfix\'></div>"
                                          +"<div class=\'days-name\'>days</div>"
                                        +"</div>"
                                        +"<div class=\'hours\'>"
                                          +"<div class=\'hours-digit\'>%H</div>"
                                          +"<div class=\'clearfix\'></div>"
                                          +"<div class=\'hours-name\'>hours</div>"
                                        +"</div>"
                                        +"<div class=\'minutes\'>"
                                          +"<div class=\'minutes-digit\'>%M</div>"
                                          +"<div class=\'clearfix\'></div>"
                                          +"<div class=\'minutes-name\'>minutes</div>"
                                        +"</div>"
                                        +"<div class=\'seconds\'>"
                                          +"<div class=\'seconds-digit\'>%S</div>"
                                          +"<div class=\'clearfix\'></div>"
                                          +"<div class=\'seconds-name\'>seconds</div>"
                                        +"</div>")
                      );
                    });
                  });
                </script>

                <style>
                	.modeltheme-countdown > div {
                		'.$box_style.'
                	}
                  .modeltheme-countdown > div > div:first-child {
                    '.$digit_style.'
                  }
                  .modeltheme-countdown > div > div:last-child {
                    '.$text_style.'
                  }
                </style>';

    echo $content;
  }
  protected function _content_template() {

  }
}