<?php
namespace Elementor;

class esio_show_portfolio_categories_widget extends Widget_Base {

  public function get_name() {
    return 'portfolio-categories-v2';
  }

  public function get_title() {
    return 'Esio - Portfolio Categories';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $knowledges = get_posts(array('post_type' => 'mt_portfolio'));
    $terms = get_terms('mt-portfolio-category2',array('hide_empty' => 0));

    $category = array();

    foreach ($terms as $term) {
         $category[$term->slug] = $term->name;
    }
    $category_title = array();

    foreach ($terms as $term) {
         $category_title[$term->name] = $term->slug;
    }

    $this->add_control(
      'category',
      [
        'label' => __( 'Select Portfolio Category', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => 'all_categories',
        'options' => $category,
      ]
    );

    $this->add_control(
      'category_title',
      [
        'label' => __( 'Select Portfolio Category Title', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => 'all_categories',
        'options' => $category_title,
      ]
    );

    $this->end_controls_section();
  }
  protected function render() {
    global $wpdb;

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $category         = $settings['category'];
    $category_title   = $settings['category_title'];

    $term = get_term_by( 'slug', $category_title, 'mt-portfolio-category2');
    if($term) {
      $img_id = '';
      $img_id = get_term_meta( $term->term_id, 'category-image-id-v2', true );
    
      $img_id_1 = '';
      $img_id_1 = get_term_meta( $term->term_id, 'category-image-id', true );

      $thumbnail_src = wp_get_attachment_image_src( $img_id, 'esio_portfolios_600x600' );
      $thumbnail_src_cat_icon = wp_get_attachment_image_src( $img_id_1, 'oklahoma_cat_icon_image' );


      $html = '';
      $html .= '<div class="mt_category_portfolio_shortcode">';

        $html .= '<div class="portfolio_category_image_shortcode_holder">';
          $html .= '<a href="'.get_site_url().'/portfolio-category/'.$category.'"><img class="cat-image" alt="cat-image" src="'.$thumbnail_src[0].'"></a>';
          $html .= '<div class="portfolio_category_footer">';
            $html .= '<div class="category_icon_holder">';
              $html .= '<img alt="cat-icon" class="cat-icon" src="'.$thumbnail_src_cat_icon[0].'">';
            $html .= '</div>';
            $html .= '<h4 class="heading"><a href="'.get_site_url().'/portfolio-category/'.$category.'">'. $category_title .'</a></h4>';
          $html .= '</div>';
        $html .= '</div>';

        $html .= '</div>';
      echo $html;
    }
}
protected function _content_template() {

  }
}