<?php 

/**
||-> Shortcode: Timeline
*/

namespace Elementor;

class esio_show_timeline_widget extends Widget_Base {
    public function get_name() {
        return 'timeline';
    }

    public function get_title() {
        return 'Esio - Timeline';
    }

    public function get_icon() {
        return 'fab fa-elementor';
    }

    public function get_categories() {
        return [ 'esio-widgets' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_title',
                [
                'label' => __( 'Content', 'modeltheme' ),
                ]
        );

        $this->add_control(
            'el_class',
                [
                    'label' => __( 'Class', 'modeltheme' ),
                    'label_block' => true,
                    'type' => Controls_Manager::TEXT,
                    'default' => '',
                    'description' => __( 'Type here the class of the widget for more styling', 'modeltheme' ),
                ]
        );

        $this->add_control(
            'timeline_version',
                [
                    'label' => __( 'Timeline Version', 'modeltheme' ),
                    'label_block' => true,
                    'type' => Controls_Manager::SELECT,
                    'default' => 'version1',
                    'description' => __( 'Choose the timeline version', 'modeltheme' ),
                    'options' => [
                        'version1' => __( 'Timeline version1', 'modeltheme' ),
                        // 'version2' => __( 'Timeline version2', 'modeltheme' ),
                    ]
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'timeline_item_title', [
                'label' => __( 'Timeline item title', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Item Title' , 'plugin-domain' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_item_content', [
                'label' => __( 'Timeiline item content', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Item content' , 'plugin-domain' ),
                'label_block' => true,
                'rows' => 10,
            ]
        );

        $repeater->add_control(
            'timeline_item_button_text', [
                'label' => __( 'Timeline item button text', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Click me' , 'plugin-domain' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_item_button_link', [
                'label' => __( 'Timeline item button link', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '#' , 'plugin-domain' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
          'timeline_item_date',
            [
              'label' => __( 'Date', 'modeltheme' ),
              'label_block' => true,
              'type' => Controls_Manager::DATE_TIME,
              'picker_options' => array('enableTime' => true, 'minuteIncrement' => 1 ),
              'default' => '2021-12-31',
              'description' => __( 'Timeline item date' , 'plugin-domain' ),
              'picker_options' => [
                'enableTime' => false,
              ],
            ]
        );

        $repeater->add_control(
          'timeline_item_date_image',
            [
              'label' => __( 'Image', 'modeltheme' ),
              'label_block' => true,
              'type' => Controls_Manager::MEDIA,
              'description' => __( 'Timeline icon' , 'plugin-domain' ),
            ]
        );

        $this->add_control(
            'timeline_events',
            [
                'label' => __( 'Timeleline Events', 'plugin-domain' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ timeline_item_title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        global $esio_redux;
        $settings = $this->get_settings_for_display();
        $el_class    = $settings['el_class'];
        $timeline_version    = $settings['timeline_version'];
        $timeline_events    = $settings['timeline_events'];

        $html = '';
        
        $html .= '<section id="cd-timeline" class="'.$timeline_version.' cd-container '.$el_class.'">';
            foreach (  $timeline_events as $event ) {
                $timeline_item_title = $event['timeline_item_title'];
                $timeline_item_content = $event['timeline_item_content'];
                $timeline_item_button_text = $event['timeline_item_button_text'];
                $timeline_item_button_link = $event['timeline_item_button_link'];
                $timeline_item_date = $event['timeline_item_date'];
                $timeline_item_date_image = $event['timeline_item_date_image']['url'];

                $html .= '<div class="mt_shortcode_timeline_items cd-timeline-block">';
                
                    $html .= '<div class="cd-timeline-img cd-picture">';
                        $html .= '<img src="'.esc_attr($timeline_item_date_image).'" data-src="'.esc_attr($timeline_item_date_image).'" alt="">';
                    $html .= '</div> <!-- cd-timeline-img -->';

                    $html .= '<div class="cd-timeline-content">';
                        $html .= '<h3 class="timeline_item_title">'.$timeline_item_title.'</h3>';
                        $html .= '<p class="timeline_item_content">'.$timeline_item_content.'</p>';
                        $html .= '<a href="'.$timeline_item_button_link.'" class="cd-read-more">'.$timeline_item_button_text.'</a>';
                        if ($timeline_item_date || !empty($timeline_item_date)) 
                        	$html .= '<p class="cd-date">'.$timeline_item_date.'</p>';
                    $html .= '</div> <!-- cd-timeline-content -->';
                $html .= '</div>';
            }

        $html .= '</section>';

        echo $html;
    }
    protected function _content_template() {

  }
}