<?php
namespace Elementor;

class esio_show_typed_text_widget extends Widget_Base {
  public function get_name() {
    return 'typed-text';
  }

  public function get_title() {
    return 'Esio - Typed text';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'texts',
        [
          'label' => __( 'Texts', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'placeholder' => __( "Eg:'First text', 'Seccont text'", 'modeltheme' ),

        ]
    );

    $this->add_control(
      'beforetext',
        [
          'label' => __( 'Beforetext', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
        ]
    );

    $this->add_control(
      'aftertext',
        [
          'label' => __( 'Aftertext', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
        ]
    );



    $this->add_control(
      'typespeed',
        [
          'label' => __( 'Typespeed', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'placeholder' => __( 'Enter typespeed in milisecconds', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'backdelay',
        [
          'label' => __( 'Backdelay- in milisecconds', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'placeholder' => __( 'Enter backdelay in milisecconds', 'modeltheme' ),
        ]
    );

    $this->end_controls_section();
  }

  protected function render() {

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $texts    = $settings['texts'];
    $aftertext    = $settings['aftertext'];
    $beforetext    = $settings['beforetext'];
    $typespeed    = $settings['typespeed'];
    $backdelay    = $settings['backdelay'];

    $typed_unique_id = 'mt_typed_text_'.uniqid();
    $skill = '';
    $skill .= '<script>
                jQuery(function(){
                    jQuery(".'.esc_attr($typed_unique_id).'").typed({
                      strings: ['.$texts.'],
                      typeSpeed: '.$typespeed.',
                      backDelay: '.$backdelay.',
                      loop: true
                    });
                });
              </script>';
    $skill .= '<div class="parent-typed-text wow">';
      $skill .= '<span class="mt_typed-beforetext">'.$beforetext.' </span>';
      $skill .= '<span class="mt_typed_text '.esc_attr($typed_unique_id).'"></span>';
      $skill .= '<span class="mt_typed-aftertext"> '.$aftertext.'</span>';
    $skill .= '</div>';
    echo $skill;
}
  protected function _content_template() {

  }
}