<?php
require_once(__DIR__.'/../vc-shortcodes.inc.arrays.php');
/**
||-> Shortcode: Posts Slider
*/
function modeltheme_shortcode_blog_slider($params, $content) {
    extract( shortcode_atts( 
        array(
            'animation'             =>'',
            'number'                =>'',
            'visible_items'         =>'',
            'category'              =>'',
        ), $params ) );
    $html = '';
    $html .= '<div class="vc_row">';
        $html .= '<div class="blog-slider-container-'.$visible_items.' owl-carousel owl-theme">';
        $available_cat = get_terms( array(
          'taxonomy' => 'category',
          'hide_empty' => false,
        ) );
        $tax_query = array( );
        if( in_array($category, $available_cat) && !empty($category) ) {
          $args = array(
            'posts_per_page'   => $number,
            'orderby'          => 'post_date',
            'order'            => 'DESC',
            'post_type'        => 'post',
            'post_status'      => 'publish',
            'tax_query'        => array(
              array(
                  'taxonomy' => 'category',
                  'field'    => 'name',
                  'terms'    => $category,
                  'compare' => 'LIKE'
                )
              ) 
            ); 
        } else {
          $args = array(
                  'posts_per_page'   => $number,
                  'orderby'          => 'post_date',
                  'order'            => 'DESC',
                  'post_type'        => 'post',
                  'post_status'      => 'publish'
                  ); 
        }

        $posts = new Wp_Query($args);
        if ( $posts->have_posts() ) {
          while ( $posts->have_posts() ) {
            $posts->the_post();
            #author meta
            $deff_author_avatar_img_url = get_template_directory_uri().'img/author-img.png';
            $author_avatar = get_avatar( get_the_author_meta( 'ID' ), 50 );
            $html.='
              <div class="wow '.$animation.' item vc_col-md-12 relative">
                <div class="blog-slider01_item">

                  <div class="blog-slider-author-info">
                    <div class="blog-slider01-img-holder">';
                      if(!empty($author_avatar)) {
                        $html.='<div class="blog-slider01-author-img">';                        
                          $html.=$author_avatar;
                        $html.='</div>';
                      } else {
                        $html.='<div class="blog-slider01-author-img">';                        
                          $html.='<img src="'.$deff_author_avatar_img_url.'" alt="author_avatar"/>';
                        $html.='</div>';
                      }
                    $html.='</div>
                    <div class="author-info">
                      <p class="author-name">'.esc_html__('Posted by ', 'modeltheme').'<strong>'.get_the_author().'</strong></p>
                      <p class="post_date">'.get_the_date().'</p>
                    </div>
                  </div>           

              
                  <div class="blog-slider01-title" >
                    <h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                  </div>
                  <div class="blog-slider01-button">
                    <a href="'.get_the_permalink().'" class="read-more">'.esc_html__('Read More', 'modeltheme').'<i class="fa fa-arrow-right"></i></a>
                    </div>
                </div>
              </div>';
          }
        }

wp_reset_postdata();
    $html .= '</div>
      </div>';
    return $html;
}
add_shortcode('blog-slider', 'modeltheme_shortcode_blog_slider');