/*
 Project name:       MODELTHEME
 Project author:     ModelTheme
 File name:          Custom JS
*/

(function ($) {
  'use strict';
  jQuery( document ).ready(function() {
    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> TESTIMONIALS01 SLIDER (Shortcode)
    */
    jQuery(".portfolio-container").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : true,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   2],
            [1000,  2],
            [1200,  2],
            [1400,  2],
            [1600,  2]
        ]
    });
    jQuery(".members-container").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        singleItem      : true,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   1],
            [700,   1],
            [1000,  1],
            [1200,  1],
            [1400,  1],
            [1600,  1]
        ]
    });
    jQuery(".testimonials-container-1").owlCarousel({
        navigation      : true, // Show next and prev buttons
        navigationText  : ["<i class='fas fa-long-arrow-left'></i>","<i class='fas fa-long-arrow-right'></i>"],
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   1],
            [700,   1],
            [1000,  1],
            [1200,  1],
            [1400,  1],
            [1600,  1]
        ]
    });
    jQuery(".testimonials-container-2").owlCarousel({
        loop:true,
        margin:20,
        nav:true,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   2],
            [1000,  2],
            [1200,  2],
            [1400,  2],
            [1600,  2]
        ]
    });
    jQuery(".testimonials-container-3").owlCarousel({
        navigation      : true, // Show next and prev buttons
        // navigationText  : ["<i class='icon-arrow-left'></i>","<i class='icon-arrow-right'></i>"],
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   2],
            [1000,  3],
            [1200,  3],
            [1400,  3],
            [1600,  3]
        ]
    });
    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> TESTIMONIALS02 SLIDER (Shortcode)
    */
    jQuery(".testimonials02-container").owlCarousel({
      navigation      : true, // Show next and prev buttons
      pagination      : true,
      autoPlay        : true,
      slideSpeed      : 700,
      paginationSpeed : 700,
      navigationText  : ["<i class='icon-arrow-left'></i>","<i class='icon-arrow-right'></i>"],
      // navigationText  : ["",""],
      singleItem      : true
    });

    $(document).ready(function() {
 
      var sync1 = $("#sync1");
      var sync2 = $("#sync2");
   
      sync1.owlCarousel({
        singleItem : true,
        slideSpeed : 1000,
        navigation: false,
        pagination:false,
        afterAction : syncPosition,
        responsiveRefreshRate : 200,
      });
     
      sync2.owlCarousel({
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   2],
            [1000,  3],
            [1200,  3],
            [1400,  3],
            [1600,  3]
        ],
        pagination:false,
        responsiveRefreshRate : 100,
        afterInit : function(el){
          el.find(".owl-item").eq(0).addClass("synced");
        }
      });
     
      function syncPosition(el){
        var current = this.currentItem;
        $("#sync2")
          .find(".owl-item")
          .removeClass("synced")
          .eq(current)
          .addClass("synced")
        if($("#sync2").data("owlCarousel") !== undefined){
          center(current)
        }
      }
     
      $("#sync2").on("click", ".owl-item", function(e){
        e.preventDefault();
        var number = $(this).data("owlItem");
        sync1.trigger("owl.goTo",number);
      });
     
      function center(number){
        var sync2visible = sync2.data("owlCarousel").owl.visibleItems;
        var num = number;
        var found = false;
        for(var i in sync2visible){
          if(num === sync2visible[i]){
            var found = true;
          }
        }
     
        if(found===false){
          if(num>sync2visible[sync2visible.length-1]){
            sync2.trigger("owl.goTo", num - sync2visible.length+2)
          }else{
            if(num - 1 === -1){
              num = 0;
            }
            sync2.trigger("owl.goTo", num);
          }
        } else if(num === sync2visible[sync2visible.length-1]){
          sync2.trigger("owl.goTo", sync2visible[1])
        } else if(num === sync2visible[0]){
          sync2.trigger("owl.goTo", num-1)
        }
        
      }
 
    });

    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> TWEETS SLIDER (Shortcode)
    */
    jQuery(".mt_tweets_slider").owlCarousel({
      navigation      : false, // Show next and prev buttons
      pagination      : false,
      autoPlay        : false,
      slideSpeed      : 700,
      paginationSpeed : 700,
      singleItem      : true
    });
    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> MEMBERS FANCY SLIDER (Shortcode)
    */
    jQuery(".mt_members_fancy_slider").owlCarousel({
      navigation      : false, // Show next and prev buttons
      pagination      : false,
      autoPlay        : false,
      slideSpeed      : 700,
      paginationSpeed : 700,
      autoPlay : true,
      autoPlayTimeout:10000,
      autoPlayHoverPause:true,
      itemsCustom : [
          [0,     1],
          [450,   1],
          [600,   2],
          [700,   2],
          [1000,  4],
          [1200,  4],
          [1400,  4],
          [1600,  4]
      ]
    });
    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> CLIENTS SLIDER (Shortcode)
    */
    jQuery(".clients_container_shortcode-1").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay : true,
        autoPlayTimeout:10000,
        autoPlayHoverPause:true,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   1],
            [700,   1],
            [1000,  1],
            [1200,  1],
            [1400,  1],
            [1600,  1]
        ]
    });
    jQuery(".clients_container_shortcode-2").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay : true,
        autoPlayTimeout:10000,
        autoPlayHoverPause:true,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   2],
            [1000,  2],
            [1200,  2],
            [1400,  2],
            [1600,  2]
        ]
    });
    jQuery(".clients_container_shortcode-3").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay : true,
        autoPlayTimeout:10000,
        autoPlayHoverPause:true,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   2],
            [1000,  3],
            [1200,  3],
            [1400,  3],
            [1600,  3]
        ]
    });
    jQuery(".clients_container_shortcode-4").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay : true,
        autoPlayTimeout:10000,
        autoPlayHoverPause:true,
        itemsCustom : [
            [0,     1],
            [450,   1],
            [600,   2],
            [700,   3],
            [1000,  4],
            [1200,  4],
            [1400,  4],
            [1600,  4]
        ]
    });
    jQuery(".clients_container_shortcode-5").owlCarousel({
        navigation      : false, // Show next and prev buttons
        pagination      : false,
        autoPlay        : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay : true,
        autoPlayTimeout:10000,
        autoPlayHoverPause:true,
        itemsCustom : [
            [0,     1],
            [450,   2],
            [600,   2],
            [700,   5],
            [1000,  6],
            [1200,  6],
            [1400,  6],
            [1600,  6]
        ]
    });

    /**
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> BLOG SLIDER
    */
    jQuery(".blog-slider-container-3").owlCarousel({
        navigation      : true, // Show next and prev buttons
        pagination      : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay        : true,
        autoPlayTimeout :10000,
        autoPlayHoverPause:true,
        navigationText  : ["<i class='fa fa-arrow-left'></i>","<i class='fa fa-arrow-right'></i>"],
        itemsCustom : [
            [0,     1],
            [450,   2],
            [600,   2],
            [700,   2],
            [1000,  2],
            [1200,  3],
            [1400,  3],
            [1600,  3]
        ]
    });
    jQuery(".blog-slider-container-2").owlCarousel({
        navigation      : true, // Show next and prev buttons
        pagination      : false,
        slideSpeed      : 700,
        paginationSpeed : 700,
        autoPlay        : true,
        autoPlayTimeout :10000,
        autoPlayHoverPause:true,
        navigationText  : ["<i class='fa fa-arrow-left'></i>","<i class='fa fa-arrow-right'></i>"],
        itemsCustom : [
            [0,     1],
            [450,   2],
            [600,   2],
            [700,   2],
            [1000,  2],
            [1200,  2],
            [1400,  2],
            [1600,  2]
        ]
    });
    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> GET DIV HEIGHT (Shortcode) 
    */
    jQuery(document).ready( function() {
        var height = jQuery(".about_image").height();
        jQuery('.about_text_holder').css('height',height);
    });
    jQuery(document).ready( function() {
        var height = jQuery(".portfolio03_thumbnail").height();
        jQuery('.color_verlay_portfolio3').css('height',height);
    });
    jQuery(document).ready( function() {
        var height = jQuery(".color_verlay_portfolio3").height();
        jQuery('.portfolio03_title_subtitle_holder').css('height',height);
    });
    /*
    * ||||||||||||||||||||||||||||||||||||||||||||||||||||||||-> SERVICES SLIDER (Shortcode)
    */
    // SET LEFT SIDE height of RIGHT SIDE
    jQuery( '.right-side' ).ready(function() {
      var right_side_height = jQuery('.right-side').height();
      jQuery( '.left-side' ).height( right_side_height )
    });
    var sync1 = jQuery("#service_big_slides");
    var sync2 = jQuery("#service_small_slides");
   
    jQuery(".service_small_slides_holder .fa-angle-right").click(function(){
      sync1.trigger('owl.next');
    })
    jQuery(".service_small_slides_holder .fa-angle-left").click(function(){
      sync1.trigger('owl.prev');
    })
    sync1.owlCarousel({
      // mouseDrag: false,
      center:true,
      loop: true,
      navigationText:  ["<",">"],
      rewindNav: true,
      singleItem : true,
      slideSpeed : 1000,
      navigation: false,
      pagination: false,
      afterAction : syncPosition,
      responsiveRefreshRate : 200,
      afterInit : function(elem){
        this.jumpTo(1);
      }
    });
   
    sync2.owlCarousel({
      // mouseDrag: false,
      center:true,
      loop: true,
      items : 3,
      itemsDesktop      : [1199,3],
      itemsDesktopSmall     : [979,3],
      itemsTablet       : [768,3],
      itemsMobile       : [479,3],
      pagination:false,
      responsiveRefreshRate : 100,
      afterInit : function(el){
        el.find(".owl-item").eq(1).addClass("synced");
      }
    });
   
    function syncPosition(el){
      var current = this.currentItem;
      jQuery("#service_small_slides")
        .find(".owl-item")
        .removeClass("synced")
        .eq(current)
        .addClass("synced")
      if(jQuery("#service_small_slides").data("owlCarousel") !== undefined){
        center(current)
      }
    }
   
    jQuery("#service_small_slides").on("click", ".owl-item", function(e){
      e.preventDefault();
      var number = jQuery(this).data("owlItem");
      sync1.trigger("owl.goTo",number);
    });
   
    function center(number){
      var sync2visible = sync2.data("owlCarousel").owl.visibleItems;
      var num = number;
      var found = false;
      for(var i in sync2visible){
        if(num === sync2visible[i]){
          var found = true;
        }
      }
   
      if(found===false){
        if(num>sync2visible[sync2visible.length-1]){
          sync2.trigger("owl.goTo", num - sync2visible.length+2)
        }else{
          if(num - 1 === -1){
            num = 0;
          }
          sync2.trigger("owl.goTo", num);
        }
      } else if(num === sync2visible[sync2visible.length-1]){
        sync2.trigger("owl.goTo", sync2visible[1])
      } else if(num === sync2visible[0]){
        sync2.trigger("owl.goTo", num-1)
      }
      
    }

    jQuery(document).ready(function($){
      jQuery('#view-demos, #view-demos a').click(function(e){
          if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
              var target = jQuery(this.hash);
              target = target.length ? target : jQuery('[name=' + this.hash.slice(1) +']');
              if (target.length) {
                  jQuery('html, body').animate({
                      scrollTop: Math.ceil(target.offset().top) 
                  }, 1000);
              return false;
              }
          }
      });
    });

    // Tabs
    jQuery('.naccs .menu div').click(function(){
      var tab_id = jQuery(this).attr('data-tab');
      jQuery('.naccs .menu div').removeClass('active');
      jQuery('.naccs ul li').removeClass('active');
      jQuery('.naccs .gc--1-of-3').removeClass('active');
      jQuery('.naccs .gc--2-of-3').removeClass('active');
      
      jQuery(this).parent().parent().addClass('active');
      jQuery("#"+tab_id).parent().parent().addClass('active');
      jQuery(this).addClass('active');
      jQuery("#"+tab_id).addClass('active');
    });
    function thisHeight(){
      return jQuery(this).height();
    }
    jQuery( ".gc.gc--1-of-3" ).on("click",function() {
      jQuery(".tabs-shortcode .gc--2-of-3").each(function() {
        var thisULMax = Math.max.apply(Math, jQuery(this).find("ul").map(thisHeight));
        jQuery(this).height(thisULMax);
      });
    });
    jQuery(".tabs-shortcode .gc--2-of-3").each(function() {
      var thisULMax = Math.max.apply(Math, jQuery(this).find("ul").map(thisHeight));
      jQuery(this).height(thisULMax);
    });
    if (jQuery('.mt-icon-list-item[class*=skin_color_]').length){
        var skin_color       = jQuery('.mt-icon-list-item[class*=skin_color_]').attr('class').split(' ');
        var skin_color_class = skin_color.filter(  function(elem){ return elem.match(/skin_color_*/) } ).join('');
        var skin_color_hexa  = skin_color_class.replace("skin_color_", "");
    }
    jQuery(".mt-icon-list-icon-holder-inner .flat-icon").flatshadow({
      fade: false,
      angle: "SE",
      color: skin_color_hexa,
    });
    jQuery( ".cd-pricing-switcher .monthly-label" ).on( "click", function() {
      jQuery( ".cd-pricing-switcher .yearly-label" ).removeClass('active');
      jQuery(this).addClass('active');
      jQuery('.package_price_per_year-parent').hide();
      jQuery('.package_price_per_month-parent').show();
    });
    jQuery( ".cd-pricing-switcher .yearly-label" ).on( "click", function() {
      jQuery( ".cd-pricing-switcher .monthly-label" ).removeClass('active');
      jQuery(this).addClass('active');
      jQuery('.package_price_per_month-parent').hide();
      jQuery('.package_price_per_year-parent').show();
    });
    jQuery(".modeltheme-pricing-vers4 .cd-pricing-list .col-md-4 .flat-icon").flatshadow({
      fade: false,
      angle: "SE",
    });
    //horizontal pricing table
    jQuery('.pricing__feature-list').children('li').on("hover",function() {
      var index = jQuery(this).index() + 1;
      jQuery('.pricing__feature-list li:nth-child(' + index + ')').toggleClass( "highlight" );
    });
    //whmcs dropdown
    jQuery(document).ready(function(){
	    jQuery(".whmcs-bridge .navbar-collapse .nav .dropdown").hover(function(e){
	      jQuery(this).find(".dropdown-menu").show(300);
	      }, function(e){
	      jQuery(this).find(".dropdown-menu").hide(300);
	    });
	  });
    if(jQuery("#bridge").length != 0) {
      jQuery('body').addClass('whmcs-bridge');
    }
    // timeline vertical bar
    $(window).load(function(){
      var last_timeline_height = jQuery('.cd-timeline-block:last-child').height();

      $('<style>#cd-timeline::before {height: calc(100% - ' + last_timeline_height + 'px);}</style>').appendTo('head');
    });
    // TIMELINE VERTICAL
    jQuery(document).ready(function($){
      var timelineBlocks = $('.cd-timeline-block'),
        offset = 0.8;

      //hide timeline blocks which are outside the viewport
      hideBlocks(timelineBlocks, offset);

      //on scolling, show/animate timeline blocks when enter the viewport
      $(window).on('scroll', function(){
        (!window.requestAnimationFrame) 
          ? setTimeout(function(){ showBlocks(timelineBlocks, offset); }, 100)
          : window.requestAnimationFrame(function(){ showBlocks(timelineBlocks, offset); });
      });

      function hideBlocks(blocks, offset) {
        blocks.each(function(){
          ( $(this).offset().top > $(window).scrollTop()+$(window).height()*offset ) && $(this).find('.cd-timeline-img, .cd-timeline-content, .cd-date, .timeline_item_title, .timeline_item_content').addClass('is-hidden');
        });
      }

      function showBlocks(blocks, offset) {
        blocks.each(function(){
          ( $(this).offset().top <= $(window).scrollTop()+$(window).height()*offset && $(this).find('.cd-timeline-img').hasClass('is-hidden') ) && $(this).find('.cd-timeline-img, .cd-timeline-content, .cd-date, .timeline_item_title, .timeline_item_content').removeClass('is-hidden').addClass('bounce-in');
        });
      }
    });
  });
} (jQuery) )
